/***************************************************************
 *                    simula.plus@cemes.fr                     *
 *                   GNU/linux version 3.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006,2007,2009,2012 COLLARD Christophe
 * copyright © 2003 CREUSE Emmanuel
 * copyright © 2003,2004,2005,2006,2007,2009,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006,2007,2009 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006,2007 Université de Valenciennes et du Hainaut-Cambrésis
 * copyright © 2003,2004,2005,2006,2007,2009 Laboratoire de Physique et Mécanique des Matériaux (LPMM - CNRS)
 * copyright © 2003,2004,2005,2006,2007 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    linear systems-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for linear systems-test
#endif

#ifndef __linear_systems_test_hpp
#define __linear_systems_test_hpp


#ifndef __iostream
#include <iostream>
#endif

#ifndef __stdio_h
#include <stdio.h>
#endif

#ifndef __stdlib_h
#include <stdlib.h>
#endif

#ifndef __time_h
#include <time.h>
#endif

#ifndef __colors_hpp
#include "colors.hpp"
#endif

#ifndef __vectors_hpp
#include "MOL++/vectors.hpp"
#endif

#ifndef __matrix_hpp
#include "MOL++/matrix.hpp"
#endif

#ifndef __linear_systems_hpp
#include "MOL++/linear systems.hpp"
#endif

#ifndef __spmatrix_hpp
#include "MOL++/spmatrix.hpp"
#endif

#ifndef __affiche_hpp
#include "tests/affiche.hpp"
#endif

using namespace mol;


//==================================
int test_linear_systems (int detail)
//==================================
{
  int result=1;
  //                   ===========================================================
  if (detail) cout << "------------------linear systems for matrix---------------- \n";
  //                   ===========================================================

  vector<double> u(9), v(9), w(9) ;

  double reel=2. , parameter = 1.6 ;
  vector<double> b(9);

  v[1] = 4 ;
  v[2] = -1 ;
  v[5] = -1 ;

  matrix<double> a(9,9) , c, d, e(9,9), f(9,9), g(9,9),h(9,9), Id(9,9) ;
  
  a[1] = v ;
  e[1] = reel*v;
  v[1] = -1 ;
  v[2] = 4 ;
  v[3] = -1 ;
  v[4] = 0 ;
  v[5] = 0 ;
  v[6] = -1 ;

  a[2] = v ;
  e[2] = reel*v;

  v[1] = 0 ;
  v[2] = -1 ;
  v[3] = 4 ;
  v[4] = -1 ;
  v[5] = 0 ;
  v[6] = 0 ;
  v[7] = -1 ;

  a[3] = v ;
  e[3] = reel*v;
  
  v[1]=0; v[2]=0; v[3]=-1; v[4]=4; v[5]=-1; v[6]=0; v[7]=0; v[8]=-1; v[9]=0;
  a[4] = v ;
  e[4] = reel*v;
  v[1]=-1; v[2]=0; v[3]=0; v[4]=-1; v[5]=4; v[6]=-1; v[7]=0; v[8]=0; v[9]=-1;
  a[5]=v;  
  e[5] = reel*v;
  v[1]=0; v[2]=-1; v[3]=0; v[4]=0; v[5]=-1; v[6]=4; v[7]=-1; v[8]=0; v[9]=0;
  a[6]=v;
  e[6] = reel*v;
  v[1]=0; v[2]=0; v[3]=-1; v[4]=0; v[5]=0; v[6]=-1; v[7]=4; v[8]=-1; v[9]=0;
  a[7]=v;
  e[7] = reel*v;
  v[1]=0; v[2]=0; v[3]=0; v[4]=-1; v[5]=0; v[6]=0; v[7]=-1; v[8]=4; v[9]=-1;
  a[8]=v;
  e[8] = reel*v;
  v[1]=0; v[2]=0; v[3]=0; v[4]=0; v[5]=-1; v[6]=0; v[7]=0; v[8]=-1; v[9]=4;
  a[9]=v;
  e[9] = v*reel;

  v[1]=18; v[2]=v[5]=-8; v[3]=v[4]=v[9]=1; v[6]=2; v[7]=v[8]=0;
  g[1]=v;
  v[1]=v[3]=v[6]=-8; v[2]=19; v[4]=1; v[5]=v[7]=2; v[8]=v[9]=0;
  g[2]=v;
  v[1]=v[5]=1; v[2]=v[4]=v[7]=-8; v[3]=19; v[6]=v[8]=2; v[9]=0;
  g[3]=v;
  v[1]=v[2]=v[6]=1; v[3]=v[5]=v[8]=-8; v[4]=19; v[7]=v[9]=2;
  g[4]=v;
  v[1]=v[4]=v[6]=v[9]=-8; v[2]=v[8]=2; v[3]=v[7]=1; v[5]=20;
  g[5]=v;
  v[1]=v[3]=2; v[2]=v[5]=v[7]=-8; v[4]=v[8]=v[9]=1; v[6]=19;
  g[6]=v;
  v[1]=0; v[2]=v[4]=2; v[3]=v[6]=v[8]=-8; v[5]=v[9]=1; v[7]=19;
  g[7]=v;
  v[1]=v[2]=0; v[3]=v[5]=2; v[4]=v[7]=v[9]=-8; v[6]=1; v[8]=19;
  g[8]=v;
  v[1]=v[6]=v[7]=1; v[2]=v[3]=0; v[4]=2; v[5]=v[8]=-8; v[9]=18;
  g[9]=v;

  v[1]=-5; v[2]=24; v[3]=18; v[4]=27; v[5]=-13; v[6]=-1; v[7]=-11; v[8]=-10; v[9]=4;

  u[1]=u[9]=1.; u[2]=u[3]=u[4]=9.; u[5]=u[7]=u[8]=0.; u[6]=2.;

  matrix<long double> aa(9,9);
  for (int i=1; i<=9; i++)
    { for (int j=1; j<i; j++)
	aa(i,j) = 2.5*i-i*j/3.;
      for (int j=i; j<=9; j++)
	aa(i,j) = (i+j)/2. - 1.2;
    }
  //  cout << "det = " << det(aa) << endl;

  vector<long double> av(9), aw(9),ab;
  av[1] = 2; av[2] = -12.36; av[3] = 7; av[4] = 0; av[5]=-12.25; av[6] = 2.2; av[7] = -2.5; av[8] = 7.25; av[9] = 3.14;
  ab = aa*av;

  if (detail) affiche ("gauss pivot partiel", gauss(a,v)==u && gauss(aa,ab)==av);
  else result *= (gauss(a,v)==u && gauss(aa,ab)==av);

  if (detail) affiche ("gauss pivot total", gauss_pt(a,v)==u && gauss_pt(aa,ab)==av);
  else result *= (gauss_pt(a,v)==u && gauss_pt(aa,ab)==av);

  matrix<long double> aaa = aa;
  for (int i=1; i<=9; i++)
    aaa(i,i) = 51*i/3; // matrice a diagonale dominante
  vector<long double> aab = aaa*av;

  int iter, itera;
  vector<double> resultat1 = gradient(a,v,b,iter,1.e-15);
  vector<long double> resultat1a = gradient(aaa,aab,aw,itera,1.e-15);
  if (detail) cout << "gradient : " << iter << " / " << itera << " iterations : ";
  if (detail) affiche ("", resultat1==u && iter==117 && resultat1a==av && itera==193);
  else result *= (resultat1==u && iter==117 && resultat1a==av && itera==193);

  resultat1 = conjugate_gradient(a,v,b,iter,1.e-15);
  resultat1a = conjugate_gradient(aaa,aab,aw,itera,1.e-15);
  if (detail) cout << "conjugate gradient : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==8 && resultat1a==av && itera==61);
  else result *= (resultat1==u && iter==8 && resultat1a==av && itera==61);

  resultat1 = jacobi(a,v,b,iter,1.e-15);
  resultat1a = jacobi(aaa,aab,aw,itera,1.e-15);
  if (detail) cout << "jacobi : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==112 && resultat1a==av && itera==77);
  else result *= (resultat1==u && iter==112 && resultat1a==av && itera==77);

  resultat1 = gauss_seidel(a,v,b,iter,1.e-15);
  resultat1a = gauss_seidel(aaa,aab,aw,itera,1.e-15);
  if (detail) cout << "gauss seidel : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==58 && resultat1a==av && itera==15);
  else result *= (resultat1==u && iter==58 && resultat1a==av && itera==15);

  int iter1,iter1a;
  long double omega = 1.;
  resultat1 = sor(a,v,b,1.,iter1,1.e-15);
  resultat1a = sor(aaa,aab,aw,omega,iter1a,1.e-15);
  if (detail) cout << "relaxation (sor) : w=1 : " << iter1 << " / " << iter1a << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==iter1 && resultat1a==av &&itera==iter1a);
  else result *= (resultat1==u && iter==iter1 && resultat1a==av &&itera==iter1a);

  omega = 0.5;
  resultat1 = sor(a,v,b,0.5,iter,1.e-15);
  resultat1a = sor(aaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "relaxation (sor) : w=0.5 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==191 && resultat1a==av && itera==66);
  else result *= (resultat1==u && iter==191 && resultat1a==av && itera==66);

  omega = 1.22;
  resultat1 = sor(a,v,b,1.22,iter,1.e-15);
  resultat1a = sor(aaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "relaxation (sor) : w=1.22 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==34 && resultat1a==av && itera==26);
  else result *= (resultat1==u && iter==34 && resultat1a==av && itera==26);

  resultat1 = ssor(a,v,b,1.22,iter,1.e-15);
  resultat1a = ssor(aaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "over relaxation (ssor) : w=1.22 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==31 && resultat1a==av && itera==27);
  else result *= (resultat1==u && iter==31 && resultat1a==av && itera==27);

/*
  resultat1 = ssor(1.22,a,v,b,epsilon,iter);
  resultat1a = ssor(omega,aaa,aab,aw,epsilon,itera);
  if (detail) cout << "gradient conjugue preconditionne ssor : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==9 && resultat1a==av && itera==21);
  else result *= (resultat1==u && iter==9 && resultat1a==av && itera==21);
*/

  resultat1 = BICGSTAB(a,v,b,iter);
  resultat1a =  BICGSTAB(aaa,aab,aw,itera);
  if (detail) cout << "BICGSTAB : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat1==u && iter==8 && resultat1a==av && itera==9);
  else result *= (resultat1==u && iter==8 && resultat1a==av && itera==9);

  if (detail) cout << endl;

  //---------------------------------------------------------------------------------------------------------------------------------

  //                   ===========================================================
  if (detail) cout << "----------------linear systems for symmatrix--------------- \n";
  //                   ===========================================================

  vector<double> sb(9);
  symmatrix<double> smata(9),sresult;
  for (int i=1; i<=9; i++) smata(i,i) = 4;
  for (int i=1; i<=8; i++) smata(i+1,i) = -1;
  for (int i=1; i<=5; i++) smata(i+4,i) = -1;

  symmatrix<double> mtrx(9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      mtrx(i,j) = mtrx(j,i) = 2*(i+j)-15*(i-j);
  u[9] = 3;

  b[1]=-1012; b[2]=-481; b[3]=-220; b[4]=-229; b[5]=-508; b[6]=-787; b[7]=-1126; b[8]=-1465; b[9]=-1804;

  symmatrix<long double> saaa(9);
  for (int i=1; i<=9; i++)
    for (int j=1; j<=i; j++)
      saaa(i,j) = aaa(j,i);
  aab = saaa * av;

  if (detail) affiche ("gauss pivot partiel", (gauss(mtrx,b) == u) && gauss(saaa,aab)==av);
  else result *= (gauss(mtrx,b) == u && gauss(saaa,aab)==av);

  if (detail) affiche ("gauss pivot total", (gauss_pt(mtrx,b) == u) && gauss_pt(saaa,aab)==av);
  else result *= (gauss_pt(mtrx,b) == u && gauss_pt(saaa,aab)==av);

  v[1]=-5; v[2]=24; v[3]=18; v[4]=27; v[5]=-13; v[6]=-1; v[7]=-11; v[8]=-10; v[9]=4;
  u[1]=u[9]=1.; u[2]=u[3]=u[4]=9.; u[5]=u[7]=u[8]=0.; u[6]=2.;
  vector<double> x0(9);
  vector<double> resultat4 = gradient(smata,v,x0,iter,1.e-15);
  vector<long double> resultat4a = gradient(saaa,aab,aw,itera,1.e-15);
  if (detail) cout << "gradient : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==117 && resultat4a==av && itera==186);
  else result *= (resultat4==u && iter==117 && resultat4a==av && itera==186);

  resultat4 = conjugate_gradient (smata,v,x0,iter,1.e-15);
  resultat4a = conjugate_gradient(saaa,aab,aw,itera,1.e-15);
  if (detail) cout << "conjugate gradient : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==8 && resultat4a==av && itera==9);
  else result *= (resultat4==u && iter==8 && resultat4a==av && itera==9);

  resultat4 = jacobi(smata,v,x0,iter,1.e-15);
  resultat4a = jacobi(saaa,aab,aw,itera,1.e-15);
  if (detail) cout << "jacobi : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==112 && resultat4a==av && itera==33);
  else result *= (resultat4==u && iter==112 && resultat4a==av && itera==33);

  resultat4 = gauss_seidel(smata,v,x0,iter,1.e-15);
  resultat4a = gauss_seidel(saaa,aab,aw,itera,1.e-15);
  if (detail) cout << "gauss seidel : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==58 && resultat4a==av && itera==14);
  else result *= (resultat4==u && iter==58 && resultat4a==av && itera==14);

  omega = 1;
  resultat4 = sor(smata,v,x0,1.,iter1,1.e-15);
  resultat4a = sor(saaa,aab,aw,omega,iter1a,1.e-15);
  if (detail) cout << "relaxation (sor) : w=1 : " << iter1 << " / " << iter1a << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==iter1 && resultat4a==av && iter1a==itera);
  else result *= (resultat4==u && iter==iter1 && resultat4a==av && iter1a==itera);

  omega = 0.5;
  resultat4 = sor(smata,v,x0,0.5,iter,1.e-15);
  resultat4a = sor(saaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "relaxation (sor) : w=0.5 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat4==u && iter==191 && resultat4a==av && itera==53);
  else result *= (resultat4==u && iter==191 && resultat4a==av && itera==53);

  omega = 1.22;
  resultat4 = sor(smata,v,x0,1.22,iter,1.e-15);
  resultat4a = sor(saaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "relaxation (sor) : w=1.22 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat4==u && iter==34 && resultat4a==av && itera==27);
  else result *= (resultat4==u && iter==34 && resultat4a==av && itera==27);

  resultat4 = ssor(smata,v,x0,1.22,iter,1.e-15);
  resultat4a = ssor(saaa,aab,aw,omega,itera,1.e-15);
  if (detail) cout << "over relaxation (ssor) : w=1.22 : " << iter << " / " << itera << " iterations :" ;
  if (detail) affiche ("", resultat4==u && iter==31 && resultat4a==av && itera==19);
  else result *= (resultat4==u && iter==31 && resultat4a==av && itera==19);

  /*
  parameter = 1.6 ;
  resultat4 = ssor(parameter,smata,v,x0,iter);
  if (detail) cout << "preconditioned conjugate gradient ssor : " << iter << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==9);
  else result *= (resultat4==u && iter==9);
  */

  resultat4 = BICGSTAB(smata,v,x0,iter);
  if (detail) cout << "BICGSTAB : " << iter << " iterations :" ;
  if (detail) affiche ("", (resultat4==u) && iter==8);
  else result *= (resultat4==u && iter==8);

  if (detail) cout << endl;

  //---------------------------------------------------------------------------------------------------------------------------------

  /*

//                   ===========================================================
if (detail) cout << "-------------test for ssor with HILBERT matrix------------- \n";
//                   ===========================================================
  int dimension = 10 ;
  symmatrix <double> hilbert(dimension) ;
  vector<double> sm(dimension), resultat5(dimension),init(dimension) ;
  for (int i = 1 ; i <= dimension ; i++ )
  {
    init[i] = 1. ;
    sm[i] = 1. ;
    for (int j = 1 ; j <= i ; j++ )
    	hilbert(i,j) = 1. / (i + j - 1 ) ;
  } ;
  iter = 2000 ;
  resultat5 = conjugate_gradient(hilbert,sm,init,iter,1.e-15) ;
  if (detail) cout << "conjugate gradient : " << iter << " iterations :" ;
  if (detail) affiche ("", (resultat5 * hilbert == sm) && iter == 1402);
  else result *= (resultat5 * hilbert == sm && iter == 1402) ;

  iter = 2000 ;
  parameter = 1.1 ;

  resultat5 = ssor(parameter,hilbert,sm,init,iter) ;

  if (detail) cout << "ssor  : " << iter << " iterations :" ;
  if (detail) affiche ("", (resultat5 * hilbert == sm) && iter == 94);
  else result *= (resultat5 * hilbert == sm && iter == 94) ;

//----------------------------------------------------------------
// Tests for " up_ssor " and " down_ssor " for " matrix "
//----------------------------------------------------------------
  parameter = 1. ;
  matrix <double> test_ssor(3,3) ;
  vector <double> result_up_ssor(3) , result_down_ssor(3) , scd(3) , result_ssor(3) ;
  test_ssor(1,1) = 4. ; test_ssor(1,2) = 2. ; test_ssor(1,3) = 1. ;
  test_ssor(2,1) = -1. ; test_ssor(2,2) = 4. ; test_ssor(2,3) = -2. ;
  test_ssor(3,1) = 0. ; test_ssor(3,2) = 1. ; test_ssor(3,3) = 9. ;
  result_ssor[1] = -1. ; result_ssor[2] = 1. ; result_ssor[3] = 2. ;

  scd[1] = -2 ; scd[2] = 2.5 ; scd[3] = 6.5 ;
  result_down_ssor = down_ssor(parameter,diagonal(test_ssor),test_ssor,scd) ;
  result *= (result_down_ssor == result_ssor) ;

  scd[1] = 0. ; scd[2] = 0. ; scd[3] = 6. ;
  result_up_ssor = up_ssor(parameter,diagonal(test_ssor),test_ssor,scd) ;
  result *= (result_up_ssor == result_ssor) ;




//----------------------------------------------------------------
// Tests for " up_ssor " and " down_ssor " for " sparse matrix "
//----------------------------------------------------------------
  parameter = 1. ;
  sparse_matrix <double> test_ssor_bis(5,5,3) ;
  vector <double> result_up_ssor_bis(5) , result_down_ssor_bis(5) , scd_bis(5) , result_ssor_bis(5) ;
  test_ssor_bis(1,1) = 4. ; test_ssor_bis(1,4) = 1. ;
  test_ssor_bis(2,1) = 1. ; test_ssor_bis(2,2) = 4. ;
  test_ssor_bis(3,3) = 9. ; test_ssor_bis(3,4) = - 1. ;
  test_ssor_bis(4,3) = 4. ; test_ssor_bis(4,4) = 4. ;
  test_ssor_bis(5,1) = 1. ; test_ssor_bis(5,4) = 1. ; test_ssor_bis(5,5) = 4. ;
  result_ssor_bis[1] = 1. ; result_ssor_bis[2] = 0. ; result_ssor_bis[3] = 2. ; result_ssor_bis[4] = - 1. ;
  result_ssor_bis[5] = 4. ;

  scd_bis[1] = 2. ; scd_bis[2] = 0.5 ; scd_bis[3] = 6. ; scd_bis[4] = 2. / 3. ; scd_bis[5] = 8. ;
  result_down_ssor_bis = down_ssor(parameter,diagonal(test_ssor_bis),test_ssor_bis,scd_bis) ;
  result *= (result_down_ssor_bis == result_ssor_bis) ;

  scd_bis[1] = 1.5 ; scd_bis[2] = 0. ; scd_bis[3] = 19. / 3. ; scd_bis[4] = - 2. ; scd_bis[5] = 8. ;
  result_up_ssor_bis = up_ssor(parameter,diagonal(test_ssor_bis),test_ssor_bis,scd_bis) ;
  result *= (result_up_ssor_bis == result_ssor_bis) ;
  
  
  
//-------------------------------------------------------------------------------------------
// Tests for sparse matrix

  int TAILLE = 100 ;
  int DIST = 10 ;
  sparse_matrix <double> sp(TAILLE,TAILLE,5) ;
  vector <double> spb(TAILLE) , spu(TAILLE) , spv(TAILLE) ;
  
//--------premier test------------------------------------------------------------
  
  for (int i = 1 ; i <= TAILLE ; i ++)
  {
  	sp(i,i) = 4 ;
	if (i > 1) sp(i,i - 1) = - 1 ;
	if (i < TAILLE) sp(i,i + 1) = - 1 ;
	if (i > DIST) sp(i,i - DIST) = - 1 ;
	if (i < TAILLE - DIST + 1)  sp(i,i + DIST) = - 1 ;
	spv[i] = 1 ;
  } ;
  
  spb = sp * spv ;
  
  iter = TAILLE ;     // max iterations
  spu = conjugate_gradient(sp,spb,spb,iter,1.e-15);
  if (detail) cout << "gradient_conjugué : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==43) ;
  else result *= (spu==spv && iter==43) ;

  iter = TAILLE ;
  parameter = 1.6 ;
  spu = ssor(parameter,sp,spb,spb,iter) ;
  if (detail) cout << "gradient_conjugué préconditionné : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==24) ;
  else result *= (spu==spv && iter==24) ;
  
  iter = TAILLE ;
  spu = BICGSTAB(sp,spb,spb,iter) ;
  if (detail) cout << "BICGSTAB : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==30) ;
  else result *= (spu==spv && iter==30) ;
  
  
//-----second test-------------------------------------
  
  for (int i = 1 ; i <= TAILLE ; i ++)
  {
  	sp(i,i) = 2.5 ;
	if (i > 1) sp(i,i - 1) = - 1 ;
	if (i < TAILLE) sp(i,i + 1) = - 1 ;
	spv[i] = 1 ;
  } ;
  
  spb = sp * spv ;
  
  iter = TAILLE ;
  spu = conjugate_gradient(sp,spb,spb,iter,1.e-15);
  if (detail) cout << "gradient_conjugué : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==91) ;
  else result *= (spu==spv && iter==91) ;

  iter = TAILLE ;
  parameter = 0.8 ;
  spu = ssor(parameter,sp,spb,spb,iter) ;
  if (detail) cout << "gradient_conjugué préconditionné : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==71) ;
  else result *= (spu==spv && iter==71) ;
  
  iter = TAILLE ;
  spu = BICGSTAB(sp,spb,spb,iter) ;
  if (detail) cout << "BICGSTAB : " << iter << " iterations :" ;
  if (detail) affiche ("", (spu==spv) && iter==88) ;
  else result *= (spu==spv && iter==88) ;
  */

  //---------------------------------------------------------------------------------------------------------------------------------


  /*
  //                   ===========================================================
  if (detail) cout << "-------------linear systems for sparse matrix-------------- \n";
  //                   ===========================================================


  cout << endl;
  */

  cout << "============================================================== \n";
  if (result) cout << green << "                linear systems test passed" << reset;
  else cout << red << "                linear systems test failed" << reset;
  cout << "============================================================== \n";
  return result;
}


#endif
